<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Google\Client;
use Google\Service\Oauth2;

class GoogleLoginController extends Controller
{
    public function index()
    {
        $client = new Client();
        $client->setClientId('YOUR_GOOGLE_CLIENT_ID');
        $client->setClientSecret('YOUR_GOOGLE_CLIENT_SECRET');
        $client->setRedirectUri(base_url('/google/callback'));
        $client->addScope('email');
        $client->addScope('profile');

        $authUrl = $client->createAuthUrl();
        return redirect()->to($authUrl);
    }

    public function callback()
    {
        $client = new Client();
        $client->setClientId('YOUR_GOOGLE_CLIENT_ID');
        $client->setClientSecret('YOUR_GOOGLE_CLIENT_SECRET');
        $client->setRedirectUri(base_url('/google/callback'));

        if ($this->request->getGet('code')) {
            $token = $client->fetchAccessTokenWithAuthCode($this->request->getGet('code'));

            if (isset($token['access_token'])) {
                $client->setAccessToken($token['access_token']);
                $oauth = new Oauth2($client);
                $userData = $oauth->userinfo->get();

                // Example: Print user data or store it in the session
                print_r($userData);
            }
        }
    }
}
