<?php

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function generateJWT($data)
{
    $key = getenv('JWT_SECRET');
    $payload = [
        'iss' => 'yourdomain.com',
        'aud' => 'yourdomain.com',
        'iat' => time(),
        'exp' => time() + 3600, // 1 hour
        'data' => $data
    ];

    return JWT::encode($payload, $key, 'HS256');
}

function validateJWT($token)
{
    $key = getenv('JWT_SECRET');
    return JWT::decode($token, new Key($key, 'HS256'));
}
